Rem
Rem $Header: deq_basic.sql 11-jul-2003.15:49:11 kbittler Exp $
Rem
Rem deq_basic.sql
Rem
Rem Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      deq_basic.sql - Dequeues a message from MGWUSER.MGW_BASIC_DEST.
Rem
Rem    DESCRIPTION
Rem      This script dequeues a message from queue MGWUSER.MGW_BASIC_DEST.
Rem      If no message is available an exception is raised.
Rem
Rem    NOTES
Rem

declare
  dequeue_options        dbms_aq.dequeue_options_t;
  message_properties     dbms_aq.message_properties_t;
  msgid                  RAW(16);
  payload		 SYS.MGW_BASIC_MSG_T;
BEGIN
  -- FIRST_MESSAGE
  dequeue_options.navigation := 1;
  dequeue_options.wait := dbms_aq.NO_WAIT;

  dbms_aq.dequeue(queue_name         => 'mgwuser.mgw_basic_dest',
                  dequeue_options    => dequeue_options,
                  message_properties => message_properties,
                  payload            => payload,
                  msgid              => msgid);

  commit;
END dequeue;
/
